<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package uTech
 * @since 1.0.0
 * 
 */
?>

<?php

	if ( is_active_sidebar( 'main-sidebar' ) ) {
		$utech_layout = 'col-lg-10 offset-lg-1';
	}else{
		$utech_layout = 'col-lg-10 offset-lg-1';
	}

	if( '1' == utech_get_option( 'enable_404_blank_header', '0') ) {
		get_header('blank');
	}else {
		get_header();
		if ( function_exists('utech_title') ) {
			utech_title();
		}
	}

?>

<div class="content-area section-padding">
    <div class="container">
        <div class="row">
			<div class="<?php echo esc_attr( $utech_layout ); ?>">
				<div class="error-404 not-found center">

					<?php 
						$error_img  = utech_get_option( 'error_page_img' );
						if( !empty( $error_img['url'] ) ) : ?>

						<div class="error__page__img">
							<img src="<?php echo esc_url( $error_img['url'] ); ?>" alt="<?php echo esc_attr__('404 Not Found', 'utech'); ?>">
						</div>
					<?php endif; ?>
					<div class="content-header">
						<?php  if( !empty( utech_get_option('error_text') ) ) : ?>
							<h3><?php echo esc_html( utech_get_option('error_text') ); ?></h3>
						<?php else : ?>
							<h3><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'utech' ); ?></h3>
						<?php endif; ?>
					</div>

					<div class="error-content">
						<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'utech' ); ?></p>
						<div class="page-search">
							<?php
								utech_search_form( true, utech_get_option( 'enable_404_search_button',true ) );
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
	if( '1' == utech_get_option( 'enable_404_blank_footer', '0') ) {
		get_footer('blank');
	}else {
		get_footer();
	}