<?php

/*-----------------------------------
    PAGE SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
	array(
		'parent' => 'Blog_Post_Page_Tab',
		'title'  => esc_html__( 'Page', 'utech' ),
		'icon'   => 'fa fa-file-text-o',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Blog & Pages Content Area Spacing ( Top / Bottom )', 'utech' ),
			),
            array(
				'id'      => 'content_spacing',
				'type'    => 'spacing',
				'title'   => esc_html__( 'Blog & Pages Spacing', 'utech' ),
				'desc'    => esc_html__( 'Set the space in blog and page content. It will be appear in top and bottom section of the page and posts.', 'utech' ),
				'left'    => false,
				'right'   => false,
				'units'   => array( 'px','px','em','%','cm','pt' ),
				'output'  => '.content-area.section-padding',
				'default' => array(
					'top'    => '100',
					'bottom' => '100',
					'unit'   => 'px',
                ),
            ),
			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Show Page Breadcrumb ', 'utech' ),
			),
		    array(
				'id'      => 'show_page_breadcrumb',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Show Page Breadcrumb ?', 'utech' ),
				'desc'    => esc_html__( 'If you want to show or hide page breadcrumb you can set ( YES / NO )', 'utech' ),
				'default' => true,
		    ),
			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Disable Next / Prev Navigation', 'utech' ),
			),
			array(
				'id'      => 'disable_page_navigation',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Disable Next / Prev Navigation', 'utech' ),
				'desc'    => esc_html__( 'If you want to enable or disable Next / Prev pagination form page you can set ( YES / NO )', 'utech' ),
				'default' => false,
			),
		),
	)
);