<?php

/*-----------------------------------
    TOP BAR SECTION
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'Header_Tab',
        'title'  => esc_html__( 'Top Bar', 'utech' ),
        'icon'   => 'fa fa-bars',
        'fields' => array(

            array(
              'type'    => 'subheading',
              'content' => esc_html__( 'Mainmenu Topbar', 'utech' ),
            ),
            array(
                'id'      => 'enable_topbar',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Topbar', 'utech' ),
                'desc'    => esc_html__( 'If you want to enable or disable topbar you can set ( YES / NO )', 'utech' ),
                'default' => false,
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Enable Elementor Topbar', 'utech' ),
                'dependency' => array( 'enable_topbar', '==', 'true' ),
            ),
            array(
                'id'      => 'add_topbar_template',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Add Topbar Template', 'utech' ),
                'desc'    => esc_html__( 'If you want to set Elementor template as topbar template you can set ( YES / NO )', 'utech' ),
                'default' => false,
                'dependency' => array( 'enable_topbar', '==', 'true' ),
            ),
            array(
                'id'      => 'elementor_topbar',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Topbar Style', 'utech' ),
                'desc'    => esc_html__( 'You can chose and select topbar type here..', 'utech' ),
                'options' => utech_get_elementor_post_array(),
                'dependency' => array( 'enable_topbar|add_topbar_template', '==|==', 'true|true' ),
            ),

            array(
                'id'         => 'phone_number',
                'type'       => 'text',
                'title'      => esc_html__( 'Phone Number', 'utech' ),
                'desc'       => esc_html__( 'Set the topbar contact phone number.', 'utech' ),
                'default'    => '+8801234567890',
                'dependency' => array( 'enable_topbar|add_topbar_template', '==|==', 'true|false' ),
            ),
            array(
                'id'         => 'email_address',
                'type'       => 'text',
                'title'      => esc_html__( 'Email Address', 'utech' ),
                'desc'       => esc_html__( 'Set the topbar contact email address.', 'utech' ),
                'default'    => 'admin@example.com',
                'dependency' => array( 'enable_topbar|add_topbar_template', '==|==', 'true|false' ),
            ),
        )
    )
);