<?php

    /*---------------------------------------
    DEFINE FILE FOLDER ROOT
    -----------------------------------------*/
    define( 'UTECH_ROOT', get_template_directory() );
    define( 'UTECH_ROOT_URI', get_template_directory_uri() );
    define( 'UTECH_ROOT_IMAGE', UTECH_ROOT_URI . '/assets/img' );
    define( 'UTECH_ROOT_CSS', UTECH_ROOT_URI . '/assets/css' );
    define( 'UTECH_ROOT_JS', UTECH_ROOT_URI . '/assets/js' );
    define( 'UTECH_ROOT_FONTS', UTECH_ROOT_URI . '/assets/fonts' );
    define( 'UTECH_ROOT_PLUGINS', UTECH_ROOT_URI . '/lib/plugins' );

    /*-----------------------------------------
    THEME SETTINGS
    ------------------------------------------*/
    define( 'UTECH_OPTION_KEY', 'utech_options' );
    define( 'UTECH_META_KEY', '_utech_page_metabox' );
    define( 'UTECH_HEADER_LAYOUT', 'header-1' );
    define( 'UTECH_HEADER_ALIGN', 'right' );

    /*---------------------------------------
    THEME LAYOUTS
    ----------------------------------------*/
    define( 'UTECH_LAYOUT', 'right_sidebar' );
    define( 'UTECH_COLUMNS', 'one_column' );

    /*----------------------------------------
    THEME VERSION CONTROL
    -----------------------------------------*/

    define( 'UTECH_DEV_MODE', false );
    if ( UTECH_DEV_MODE || WP_DEBUG ) {
        define( 'UTECH_VERSION', time() );
    } else {
        define( 'UTECH_VERSION', wp_get_theme()->get( 'Version' ) );
    }

    /*----------------------------------------
    ADD THEME AFTER SETUP FUNCTIONALITY
    -----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/setup.php' ) ) {
        require_once UTECH_ROOT . '/inc/setup.php';
    }

    /*----------------------------------------
    ADD THEME WIDGET FUNCTIONALITY
    -----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/widgets.php' ) ) {
        require_once UTECH_ROOT . '/inc/widgets.php';
    }

    /*----------------------------------------
     * IMPLEMENT ALL SCRIPTS
    -----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/scripts.php' ) ) {
        require_once UTECH_ROOT . '/inc/scripts.php';
    }

    /*--------------------------------------
    CUSTOM FUNCTIONS .
    ----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/custom-functions.php' ) ) {
        require_once UTECH_ROOT . '/inc/custom-functions.php';
    }

    /*--------------------------------------
    THEME OPTON & CUSTOMIZER ADDITIONS.
    ----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/Options/Init.php' ) ) {
        require_once UTECH_ROOT . '/Options/Init.php';
    }

    if ( file_exists( UTECH_ROOT . '/inc/customizer.php' ) ) {
        require_once UTECH_ROOT . '/inc/customizer.php';
    }

    /*----------------------------------------
     *     CUSTOM TEMPLATE TAGS FOR THIS THEME.
    ----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/template-tags.php' ) ) {
        require_once UTECH_ROOT . '/inc/template-tags.php';
    }

    /*--------------------------------------
    FUNCTIONS WHICH ENHANCE THE THEME BY HOOKING INTO WORDPRESS.
    ----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/template-functions.php' ) ) {
        require_once UTECH_ROOT . '/inc/template-functions.php';
    }

    /*--------------------------------------
    BREADCRUMBS
    ---------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/breadcrumb.php' ) ) {
        require_once UTECH_ROOT . '/inc/breadcrumb.php';
    }

    /*--------------------------------------
    FUNCTIONS FOR THEME OPTIONS STYEING.
    ----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/style.php' ) ) {
        require_once UTECH_ROOT . '/inc/style.php';
    }

    /*--------------------------------------
    CUSTOM NAV WALKER .
    ----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/nav-menu-walker.php' ) && !defined( 'ELEMENTOR_VERSION' ) ) {
        require_once UTECH_ROOT . '/inc/nav-menu-walker.php';
    }

    if ( file_exists( UTECH_ROOT . '/inc/nav-menu-walker-elementor.php' ) && defined( 'ELEMENTOR_VERSION' ) ) {
        require_once UTECH_ROOT . '/inc/nav-menu-walker-elementor.php';
    }

    /*--------------------------------------
    DEMO CONTENT IMPORTER
    ---------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/importer.php' ) ) {
        require_once UTECH_ROOT . '/inc/importer.php';
    }
    if ( file_exists( UTECH_ROOT . '/inc/importer_alt.php' ) ) {
        require_once UTECH_ROOT . '/inc/importer_alt.php';
    }

    /*--------------------------------------
    REQUIRED PLUGINS.
    ----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/inc/required-plugins.php' ) ) {
        require_once UTECH_ROOT . '/inc/required-plugins.php';
    }

    /*--------------------------------------
    FEATURES & FRAMEWORKS.
    ----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/edd/edd_setup.php' ) ) {
        require_once UTECH_ROOT . '/edd/edd_setup.php';
    }

    if ( file_exists( UTECH_ROOT . '/edd/acf-fields.php' ) ) {
        require_once UTECH_ROOT . '/edd/acf-fields.php';
    }

    /*--------------------------------------
    Load WooCommerce Compatibility File.
    ----------------------------------------*/
    if ( file_exists( UTECH_ROOT . '/woocommerce/woo-setup.php' ) ) {
        require_once UTECH_ROOT . '/woocommerce/woo-setup.php';
    }