<?php

if( !class_exists( 'OCDI_Plugin' ) ) {
    return;
}

/* -----------------------------
    Import Page Setup
 -------------------------------*/
function utech_demo_page_setup( $default_settings ) {
    $default_settings['parent_slug'] = 'themes.php';
    $default_settings['page_title']  = esc_html__( 'uTech Demo Content Importer', 'utech' );
    $default_settings['menu_title']  = esc_html__( 'Import uTech Demo', 'utech' );
    $default_settings['capability']  = 'import';
    $default_settings['menu_slug']   = 'utech-demo-import';

    return $default_settings;
}
add_filter( 'ocdi/plugin_page_setup', 'utech_demo_page_setup' );

/* ----------------------------
    Impport Files
-------------------------------*/
function utech_import_files() {

    $preview_url = wp_get_theme()->get( 'ThemeURI' );
    $demo_content_source = $preview_url . '/content';
    $demo_install_notice = esc_html__( 'Thank You! for installing uTech demo content. Make sure all the required plugins are activated.', 'utech' );

    return array(
        array(
            'import_file_name'           => 'Home V1',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_1.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/',
        ),
        array(
            'import_file_name'           => 'Home V2',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_2.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v2',
        ),
        array(
            'import_file_name'           => 'Home V3',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_3.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v3',
        ),
        array(
            'import_file_name'           => 'Home V4',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_4.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v4',
        ),
        array(
            'import_file_name'           => 'Home V5',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_5.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v5',
        ),
        array(
            'import_file_name'           => 'Home V6',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_6.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v6',
        ),
        array(
            'import_file_name'           => 'Home V7',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_7.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v7',
        ),
        array(
            'import_file_name'           => 'Home V8',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_8.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v8',
        ),
        array(
            'import_file_name'           => 'Home V9',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_9.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v9',
        ),
        array(
            'import_file_name'           => 'Home V10',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_10.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v10',
        ),
        array(
            'import_file_name'           => 'Home V11',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_11.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v11',
        ),
        array(
            'import_file_name'           => 'Home V12',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_12.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v12',
        ),
        array(
            'import_file_name'           => 'Home V13',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_13.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v13',
        ),
        array(
            'import_file_name'           => 'Home V14',
            'import_file_url'            => $demo_content_source . '/content.xml',
            'import_widget_file_url'     => $demo_content_source . '/widgets.wie',
            'import_customizer_file_url' => $demo_content_source . '/customizer.dat',
            'import_settings_file_url'   => $demo_content_source . '/uTech_Options.json',
            'import_preview_image_url'   => $demo_content_source . '/home_14.jpg',
            'import_notice'              => $demo_install_notice,
            'preview_url'                => $preview_url . '/home-v14',
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'utech_import_files' );

/*------------------------------
Get Option Unserialize Data
-------------------------------*/
function utech_get_cs_decode_string( $string = '' ) {
    return json_decode( $string , true );
}

/*------------------------------
Before Widget Import
-------------------------------*/
function utech_before_widgets_import( $selected_import ) {

    // Remove 'Hello World!' post
    wp_delete_post( 1, true );
    // Remove 'Sample page' page
    wp_delete_post( 2, true );
    $sidebars_widgets            = get_option( 'sidebars_widgets' );
    $sidebars_widgets['sidebar'] = array();
    update_option( 'sidebars_widgets', $sidebars_widgets );

}
add_action('pt-ocdi/before_widgets_import', 'utech_before_widgets_import');

/* ----------------------------
    Setup Menu & Home After Import
-------------------------------*/
function utech_after_import( $selected_import ) {

    $options_file_path = isset( $selected_import['import_settings_file_url'] ) ? $selected_import['import_settings_file_url'] : '';
    if ( $options_file_path ) {
        $options_raw_data = OCDI\Helpers::data_from_file( $options_file_path );
        if ( !is_wp_error( $options_raw_data ) ) {
            update_option( 'utech_options', utech_get_cs_decode_string( $options_raw_data ) );
        }
    }

    $selected_home = $selected_import['import_file_name'];
    $front_page_id = get_page_by_title( $selected_home );
    $blog_page_id  = get_page_by_title( 'Blog' );
    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
    set_theme_mod( 'nav_menu_locations', array(
        'mainmenu' => $main_menu->term_id,
    ));

}
add_action( 'ocdi/after_import', 'utech_after_import' );

/* ----------------------------
    DISABLE REGENERATE THUMBNAIL
-------------------------------*/
add_filter( 'ocdi/regenerate_thumbnails_in_content_import', '__return_false' );