<?php

/**
*   Register Google Fonts.
*/

if ( !function_exists( 'utech_get_google_font_url' ) ) {
    function utech_get_google_font_url() {
        $fonts_url = '';
        $fonts     = array();
        $subsets   = 'latin,latin-ext';
        
        /* translators: If there are characters in your language that are not supported by Merriweather, translate this to 'off'. Do not translate into your own language. */        
        if ( 'off' !== esc_html_x( 'on', 'Barlow Condensed font: on or off', 'utech' ) ) {
            $fonts[] = esc_html( 'Barlow+Condensed:300,400,500,600,700,800,900' );
        }

        if ( 'off' !== esc_html_x( 'on', 'Roboto font: on or off', 'utech' ) ) {
            $fonts[] = esc_html( 'Roboto:300,400,500,600,700' );
        }
        
        if ( $fonts ) {
            $fonts_url = add_query_arg( array(
                'family' => implode( '|', $fonts ),
                'subset' => $subsets,
            ), '//fonts.googleapis.com/css' );
        }
        return esc_url_raw( $fonts_url );
    }
}

/**
 * Enqueue scripts
 *
 * @param string $handle Script name
 * @param string $src Script url
 * @param array $deps (optional) Array of script names on which this script depends
 * @param string|bool $ver (optional) Script version (used for cache busting), set to null to disable
 * @param bool $in_footer (optional) Whether to enqueue the script before </head> or before </body>
 */

/**
 * Enqueue scripts and styles.
 */

if ( !function_exists( 'utech_scripts' ) ) :

	function utech_scripts() {

		/************************************
		*	    ALL CSS SCRIPTS HERE.       *
		*************************************/
        /*----------------------------
            GOOGLE FONTS
        -----------------------------*/
        wp_enqueue_style( 'utech-google-font', utech_get_google_font_url() );
        
        /*----------------------------
            THEME DEFAULT STYLESHEET
        -----------------------------*/
		wp_enqueue_style( 'utech-style', get_stylesheet_uri(), array(), UTECH_VERSION, 'all' );

        /*----------------------------
            PLUGINS
        -----------------------------*/
        wp_enqueue_style( 'animate', UTECH_ROOT_CSS .'/plugins/animate.css', array(), '1.0.0', 'all' );
        wp_enqueue_style( 'owl-carousel', UTECH_ROOT_CSS .'/plugins/owl.carousel.css', array(), '2.0.0', 'all' );
        wp_enqueue_style( 'stellarnav', UTECH_ROOT_CSS .'/plugins/stellarnav.min.css', array(), '2.0.0', 'all' );
        wp_enqueue_style( 'selectbox', UTECH_ROOT_CSS .'/plugins/jquery.selectbox.css', array(), '2.0.0', 'all' );
        wp_enqueue_style( 'nice-select', UTECH_ROOT_CSS .'/plugins/nice-select.css', array(), '2.0.0', 'all' );
        wp_enqueue_style( 'bootstrap', UTECH_ROOT_CSS .'/plugins/bootstrap.min.css', array(), '4.6.0', 'all' );

        /*----------------------------
            FONTS ICON
        -----------------------------*/
        wp_enqueue_style( 'themify', UTECH_ROOT_CSS .'/icons/themify-icons.css', array(), '1.0.0', 'all' );
        wp_enqueue_style( 'beicon', UTECH_ROOT_CSS .'/icons/beicon.css', array(), '1.0.0', 'all' );
        wp_enqueue_style( 'fontawesome', UTECH_ROOT_CSS .'/icons/font-awesome.min.css', array(), '1.0.0', 'all' );

        /*----------------------------
            MAIN STYLESHEET
        ----------------------------*/
        wp_enqueue_style( 'utech-default', UTECH_ROOT_CSS .'/default.css', array(), UTECH_VERSION, 'all' );
        wp_enqueue_style( 'utech-typography', UTECH_ROOT_CSS .'/typography.css', array(), UTECH_VERSION, 'all' );
		wp_enqueue_style( 'utech-header', UTECH_ROOT_CSS .'/header.css', array(), UTECH_VERSION, 'all' );
		wp_enqueue_style( 'utech-blog', UTECH_ROOT_CSS .'/blog-and-pages.css', array(), UTECH_VERSION, 'all' );
		wp_enqueue_style( 'utech-footer', UTECH_ROOT_CSS .'/footer.css', array(), UTECH_VERSION, 'all' );
		wp_enqueue_style( 'utech-main-style', UTECH_ROOT_CSS .'/features.css', array(), UTECH_VERSION, 'all' );


		/*************************************
            ALL JQUERY SCRIPTS HERE
		**************************************/
        wp_enqueue_script( 'bootstrap', UTECH_ROOT_JS . '/vendor/bootstrap.bundle.min.js', array( 'jquery' ), '4.6.0', true );
        wp_enqueue_script( 'jquery-effects-core' );
        wp_enqueue_script( 'owl-carousel', UTECH_ROOT_JS . '/owl.carousel.min.js', array( 'jquery' ), '2.0.0', true );
        wp_enqueue_script( 'wow', UTECH_ROOT_JS . '/wow.min.js', array( 'jquery' ), '1.1.2', true );
        wp_enqueue_script( 'loadScroll', UTECH_ROOT_JS . '/loadScroll.js', array( 'jquery' ), '1.1.2', true );
        wp_enqueue_script( 'stellarnav', UTECH_ROOT_JS . '/stellarnav.min.js', array( 'jquery' ), '2.0.0', true );
        wp_enqueue_script( 'selectbox', UTECH_ROOT_JS . '/jquery.selectbox.min.js', array( 'jquery' ), '1.0.0', true );
        wp_enqueue_script( 'nice-select', UTECH_ROOT_JS . '/nice-select.min.js', array( 'jquery' ), '1.0.0', true );
        wp_enqueue_script( 'fitvids', UTECH_ROOT_JS . '/jquery.fitvids.js', array( 'jquery' ), '1.1.0', true );
        wp_enqueue_script( 'placeholdem', UTECH_ROOT_JS . '/placeholdem.min.js', array( 'jquery' ), '1.0.0', true );
        wp_enqueue_script( 'menu-sticky', UTECH_ROOT_JS . '/jquery.sticky.js', array( 'jquery' ), '1.0.4', true );
        wp_enqueue_script( 'footer-reval', UTECH_ROOT_JS . '/footer-reveal.min.js', array( 'jquery' ), '1.0.0', true );
        wp_enqueue_script( 'resize-sensor', UTECH_ROOT_JS . '/ResizeSensor.min.js', array( 'jquery' ), '1.0.0', true );
        wp_enqueue_script( 'sticky-sidebar', UTECH_ROOT_JS . '/theia-sticky-sidebar.min.js', array( 'jquery' ), '1.0.0', true );
        wp_enqueue_script( 'masonry', array( 'jquery', 'imagesloaded' ) );
        wp_enqueue_script( 'utech-active', UTECH_ROOT_JS . '/main.js', array( 'jquery' ), UTECH_VERSION, true );

        if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
            wp_enqueue_script( 'comment-reply' );
        }
	}

endif;
add_action( 'wp_enqueue_scripts', 'utech_scripts' );
