<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package uTech
 * @since 1.0.0
 */

get_header();

?>
<?php 
    if (function_exists('utech_title')) {
        utech_title();
    }
?>
<div class="content-area section-padding">
    <div class="container">
        <div class="row">

                <?php if( 'left_sidebar' == utech_blog_details_layout('sidebar') ) : ?>
                    <?php get_sidebar(); ?>
                <?php endif; ?>

			<div class="<?php echo esc_attr( utech_blog_details_layout('columns') ); ?>">
				<?php while ( have_posts() ) : the_post(); ?>
                    <?php
    					get_template_part( 'template-parts/content/content', get_post_format() );
                        if ( wp_count_posts('post')->publish > 1 ) {
                            utech_post_navigation();
                        }
                        utech_related_posts_query();
                        get_template_part( 'template-parts/post/author-bio' );
                        if ( comments_open() || get_comments_number() ) :
                            comments_template(); 
                        endif;
                    ?>
                <?php endwhile; ?>
			</div>

                <?php if( 'right_sidebar' == utech_blog_details_layout('sidebar') ) : ?>
                    <?php get_sidebar(); ?>
                <?php endif; ?>
        </div>
    </div>
</div>
<?php
get_footer();