<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package uTech
 */

?>
<article id="post-<?php the_ID();?>" <?php post_class(); ?>>
    <?php
        if ( function_exists('utech_video_preview') ) {
            echo utech_video_preview();
        }
    ?>
    <div class="post-details">
        <?php 
            if ( 'post' === get_post_type() && !is_single() ) {
                utech_single_random_category_retrip();
            }
        ?>
        <?php 
            if ( get_the_title() ) {
                if ( ! is_single() ) {
                    the_title( '<h3 class="post-title"><a href="' . esc_url( get_permalink() ) . '">', '</a></h3>' );
                }
            }
        ?>
        <?php
            if ( 'post' === get_post_type() && is_single() ) {
                utech_single_post_top_meta();
            }
        ?>
        <div class="post-content fix">
            <?php
                if ( is_single() ) {
                    the_content();
                }else{
                    the_excerpt();
                }
                if ( is_single() ) {
                    utech_link_pages();
                }
            ?>
        </div>
        <?php
            if ( !is_single() ) {
                utech_posts_bottom_meta();
            }
            if( is_single() ) {            
                if(function_exists('utech_post_footer_meta')){
                    utech_post_footer_meta();
                }
            }
        ?>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->