<?php
	/*-------------------------------
	    MAIN MENU
	--------------------------------*/
	if ( !function_exists('utech_menu')) {
		function utech_menu(){
			/*-----------------------
				PAGE META DATA
			-------------------------*/
			$page_meta              = utech_metabox_value('_utech_page_metabox');
			$enable_header_styling = isset( $page_meta['enable_header_styling'] ) ? $page_meta['enable_header_styling'] : false;
			$enable_header_category_search = isset( $page_meta['enable_header_category_search'] ) ? $page_meta['enable_header_category_search'] : false;

	        if ( is_page() && $enable_header_styling == true ) {
	        	if ( !empty($page_meta['menu_width']) ) {
	        		$menu_width = $page_meta['menu_width'];
	        	}
	        }else{
	        	$menu_width = utech_get_option( 'menu_width', 'container container__full' );
	        }
	    ?>
	    <div class="header-top-area">
	        
	        <!-- MAINMENU AREA -->
	        <div class="mainmenu-area" id="mainmenu-area">
	            <div class="mainmenu-area-bg"></div>
	            <nav class="navbar">
	                <div class="no-padding <?php echo esc_attr( $menu_width ); ?>">
	                    <div class="no-margin row">
	                        <div class="no-padding col-md-12 flex-v-center offcanvas__mobile__nav">
	                        	<div class="push__header__action">
									<div class="push__menu__button">
										<div class="offcanvas__menu__open__trigger" id="offcanvas__menu__open__trigger">
											<img src="<?php echo UTECH_ROOT_IMAGE . '/menu__grid.svg'; ?>" alt="<?php bloginfo( 'title' ); ?>">
										</div>
									</div>
									<div class="top-left-contact hidden-xs hidden-sm hidden-md">

									    <?php if( !empty( utech_get_option( 'phone_number' ) ) ): ?>
									    <div class="topbar-single-contact">
									        <div class="topbar__contact__heading"><?php echo esc_html__( 'Call Us', 'utech' ); ?></div>
									        <div class="topbar__contact__details"><?php echo esc_html( utech_get_option( 'phone_number' ) ); ?></div>
									    </div>
									    <?php endif; ?>

									    <?php if( !empty( utech_get_option( 'email_address' )  ) ): ?>
									    <div class="topbar-single-contact">
									        <div class="topbar__contact__heading"><?php echo esc_html__( 'Mail To', 'utech' ) ?></div>
									        <div class="topbar__contact__details"><?php echo esc_html( utech_get_option( 'email_address' )  ); ?></div>
									    </div>
									    <?php endif; ?>

									</div>
	                        	</div>
	                        	<div class="stellarnav"></div>
	                            <?php if( '1' == utech_get_option( 'enable_header_actions', false ) ) : ?>  
	                            <div class="header-action">
									<?php get_template_part( 'template-parts/header/actions/action', 'button' ); ?>
	                            </div>
	                        	<?php endif; ?>
	                        </div>
	                    </div>
	                </div>
	            </nav>
	        </div>
	        <!-- END MAINMENU AREA END -->

		    <!-- OFFCANVAS MENU START -->
		    <div class="offcanvas__mobile__menu__main__wrapper" id="offcanvas__mobile__menu__main__wrapper">
		        <div  class="offcanvas__menu__close__trigger" id="offcanvas__menu__close__trigger">
		            <img src="<?php echo UTECH_ROOT_IMAGE . '/cross.svg'; ?>" alt="<?php bloginfo( 'title' ); ?>">
		        </div>
		        <div class="offcanvas__menu__wrapper">
		            <div class="offcanvas__menu__inner__content">
		                <div class="offcanvas__search__area">
		                    <?php echo get_search_form(); ?>
		                </div>
                        <?php
                            wp_nav_menu( array(
								'theme_location'  => 'mainmenu',
								'menu_id'         => 'offanvas__menu',
								'menu'            => 'ul',
								'menu_class'      => 'offanvas__menu',
								'container'       => 'nav',
								'container_class' => 'offcanvas__navigation',
								'container_id'    => 'offcanvas__wrap',
								'fallback_cb'     => 'utech_menu_default_fallback',
								'walker'          => new utech_Nav_Menu_Walker(),
                            ) );
                        ?>
		            </div>
		        </div>
		    </div>
			<!-- OFFCANVAS MENU END -->		    

	    </div>
	    <?php
		}
	}

    if (function_exists('utech_menu')) {
        utech_menu();
    }
?>