<?php

/*-----------------------------------
SHOP PAGE
------------------------------------*/
CSF::createSection( UTECH_OPTION_KEY,
    array(
        'parent' => 'WooCommerce_Tab',
        'title'  => esc_html__( 'Shop Page', 'utech' ),
        'icon'   => 'fa fa-th',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Shop Container', 'utech' ),
            ),
            array(
                'id'      => 'shop_container_width',
                'type'    => 'select',
                'title'   => esc_html__( 'Shop Container Width', 'utech' ),
                'desc'    => esc_html__( 'Set the prodcut container widht with form here you can set ( FULLWIDTH / CONTAINER )', 'utech' ),
                'options' => array(
                    'container'                 => esc_html__( 'Container', 'utech' ),
                    'container container__full' => esc_html__( 'Container Full Width', 'utech' ),
                    'container-fluid'           => esc_html__( 'Full Width', 'utech' ),
                ),
                'default' => 'container',
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Shop Page Layout', 'utech' ),
            ),
            array(
                'id'      => 'shop_pages_layout',
                'type'    => 'image_select',
                'title'   => esc_html__( 'Shop Layout', 'utech' ),
                'desc'    => esc_html__( 'You can chose and select shop layout style type from here. NOTE: If you select left or right sidebar but not use any widget it will get 10 columns.', 'utech' ),
                'options' => array(
                    'left_sidebar'  => UTECH_ROOT_IMAGE . '/pages/3/left_sidebar.png',
                    'right_sidebar' => UTECH_ROOT_IMAGE . '/pages/3/right_sidebar.png',
                    'full_width'    => UTECH_ROOT_IMAGE . '/pages/3/full_width.png',
                ),
                'default' => 'right_sidebar',
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Shop Page Title & Description', 'utech' ),
            ),
            array(
                'id'      => 'shop_page_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Shop Page Title', 'utech' ),
                'desc'    => esc_html__( 'Set the main shop page title here like ( Our Shop )', 'utech' ),
                'default' => 'Shop Page',
            ),
            array(
                'id'      => 'enable_shop_description',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Shop Description?', 'utech' ),
                'desc'    => esc_html__( 'If you want to set shop description text you can set ( YES / NO )', 'utech' ),
                'default' => true,
            ),
            array(
                'id'      => 'custom_shop_description',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Custom Shop Description?', 'utech' ),
                'desc'    => esc_html__( 'If you want to set custom shop description text you can set ( YES / NO )', 'utech' ),
                'default' => false,
                'dependency' => array( 'enable_shop_description', '==', 'true' ),
            ),
            array(
                'id'         => 'shop_page_description',
                'type'       => 'text',
                'title'      => esc_html__( 'Shop Description Title', 'utech' ),
                'desc'       => esc_html__( 'Set your preferred custom shop description title.', 'utech' ),
                'default'    => esc_html__( 'Your Description Text Here', 'utech' ),
                'dependency' => array( 'enable_shop_description|custom_shop_description', '==|==', 'true|true' ),
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Shop Page Default Options', 'utech' ),
            ),
            array(
                'id'      => 'product_per_page',
                'type'    => 'slider',
                'title'   => esc_html__( 'Product Per Page', 'utech' ),
                'desc'    => esc_html__( 'Set the product that how many product you want to show in shop page loop.', 'utech' ),
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
                'unit'    => ' ',
                'default' => 12,
            ),
            array(
                'id'      => 'product_per_row',
                'type'    => 'slider',
                'title'   => esc_html__( 'Product Per Row', 'utech' ),
                'desc'    => esc_html__( 'Set the product per row that how many product you want to show in shop page per row in loop.', 'utech' ),
                'min'     => 1,
                'max'     => 6,
                'step'    => 1,
                'unit'    => ' ',
                'default' => 3,
            ),
            array(
                'id'      => 'sticky_shop_sidebar',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Sticky Sidebar ?', 'utech' ),
                'desc'    => esc_html__( 'You can set sticky blog page sidebar here. just set ( YES / NO ) for OFF or ON.', 'utech' ),
                'default' => true,
            ),
            array(
                'id'      => 'show_shop_pagination',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Show Shop Pagination ?', 'utech' ),
                'desc'    => esc_html__( 'You can set show or hide shop pagination set ( YES / NO ) for OFF or ON.', 'utech' ),
                'default' => true,
            ),
        ),
    )
);