<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header();

do_action( 'woocommerce_page_header' );

$container = utech_get_option('shop_container_width','container');
if( isset( $_REQUEST['layout'] ) ){
	$container = $_REQUEST['layout'];
}


?>

<div class="content-area section-padding">
	<div class="<?php echo esc_attr( $container ); ?>">
		<div class="row">

			<?php
				if( 'left_sidebar' == utech_shop_layout('sidebar') ) {
					get_template_part( 'woocommerce/sidebar-shop' );
				}
			?>

			<div class="<?php echo esc_attr( utech_shop_layout('columns') ); ?>">
				<?php
					/**
					 * Hook: woocommerce_before_main_content.
					 *
					 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
					 * @hooked woocommerce_breadcrumb - 20
					 * @hooked WC_Structured_Data::generate_website_data() - 30
					 */
					do_action( 'woocommerce_before_main_content' );
					
				?>


					<?php
						if ( woocommerce_product_loop() ) {

							?>

							<div class="woocommerce__products__topbar">
								<?php do_action('utech_girdlist_view_toggle'); ?>
								<?php woocommerce_result_count(); ?>
								<?php woocommerce_catalog_ordering(); ?>
							</div>

							<?php
								/**
								 * Hook: woocommerce_before_shop_loop.
								 *
								 * @hooked woocommerce_output_all_notices - 10
								 * @hooked woocommerce_result_count - 20
								 * @hooked woocommerce_catalog_ordering - 30
								 */
								do_action( 'woocommerce_before_shop_loop' );
							?>
							<?php

							woocommerce_product_loop_start();

							if ( wc_get_loop_prop( 'total' ) ) {
								while ( have_posts() ) {
									the_post();

									/**
									 * Hook: woocommerce_shop_loop.
									 */
									do_action( 'woocommerce_shop_loop' );

									wc_get_template_part( 'content', 'product' );
								}
							}

							woocommerce_product_loop_end();

							/**
							 * Hook: woocommerce_after_shop_loop.
							 *
							 * @hooked woocommerce_pagination - 10
							 */
							do_action( 'woocommerce_after_shop_loop' );
						} else {
							/**
							 * Hook: woocommerce_no_products_found.
							 *
							 * @hooked wc_no_products_found - 10
							 */
							do_action( 'woocommerce_no_products_found' );
						}

					?>

				<?php
					/**
					 * Hook: woocommerce_after_main_content.
					 *
					 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
					 */
					do_action( 'woocommerce_after_main_content' );
				?>
			</div>

			<?php
				if( 'right_sidebar' == utech_shop_layout('sidebar') ) {
					get_template_part( 'woocommerce/sidebar-shop' );
				}
			?>

		</div>
	</div>
</div>

<?php
get_footer();
